#!/bin/bash

#debug
set -x
set -e
set -u

# kernel update
#emerge --update --newuse --deep --with-bdeps=y @world -a -b
emerge --update --newuse --deep --with-bdeps=y @world -a -k
emerge --config sys-kernel/gentoo-kernel
emerge -a -1 gentoo-kernel @module-rebuild

# dispatch conf
dispatch-conf

# dracut
dracut --force

# grub reinstall
grub-install /dev/sda

# grub update
grub-mkconfig -o /boot/grub/grub.cfg

